/*global define, require, console */
/*jslint white: true, nomen: true */

define(["lib/Zoot", "lib/dev", "lib/tasks", "lib/tasks/treeOfMatrix"], 
function (Z, dev, tasks, treeOfMatrix) {
	"use strict";

	var kAbout = "$$$/private/animal/Behavior/Replicator/About=Replicator, (c) 2014.",
		vec2 = Z.Vec2,
		m3 = Z.Mat3,
		rKeyCode = Z.keyCodes.getKeyGraphId("R"),
		dKeyCode = Z.keyCodes.getKeyGraphId("D");

	var kAffine = tasks.dofs.type.kAffine;

    return {
		about: kAbout,
		description: "$$$/private/animal/Behavior/Replicator/Desc=Replicates an object",
		uiName:	"$$$/private/animal/Behavior/Replicator/UIName=Replicator",
		hideInBehaviorList: true, // REMOVE THIS TO HAVE THE BEHAVIOR SHOW UP IN THE UI! (or hold down opt/alt when clicking the menu)
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{
					id: "ReplicateWhileMouseDown",
					type: "checkbox",
					uiName: "$$$/private/animal/Behavior/Replicator/Parameter/ReplicateWhileMouseDown=Replicate While Mouse Down",
					dephault: false
				},
				{ id: "MouseInput", type: "eventGraph", uiName: "$$$/private/animal/Behavior/Replicator/Parameter/MouseInput=Mouse and Touch Input", inputKeysArray: ["Mouse/", "Touch/"],
					uiToolTip: "$$$/private/animal/Behavior/Replicator/Parameter/MouseInput/tooltip=Mouse and Touch input used for object creation", defaultArmedForRecordOn: true },
				{ id: "KeyboardInput", type: "eventGraph", uiName: "$$$/private/animal/Behavior/Replicator/Parameter/KeyboardInput=Keyboard Input", inputKeysArray: [rKeyCode, dKeyCode],
					uiToolTip: "$$$/private/animal/Behavior/Replicator/Parameter/KeyboardInput/tooltip=Keyboard input used to interact to create and delete objects", defaultArmedForRecordOn: true }
			];
		},

		onCreateBackStageBehavior: function (self) {
			// method on backstage behavior just before it is attached to a puppet; self is the new backstage behavior
			// which will contain these properties: boundPuppet, projectBehavior, getParam(id)/setParam(id, value) [or just allow this.id syntax?], addParam(), removeParam(),  
			// here you might walk the handles of your puppet and bind handle parameters or change defaults accordingly
			// the already-bound other behaviors can be examined, and this function can return a suggested index for its order,
			// and also its priority (i.e. how many simulation time-slices per rendered frame)
		},

		onCreateStageBehavior: function (self, args) {
			self.lastDown = 0;
			self.aParticleLayer = [];
			self.particleTrack = new Z.Track("ReplicatorTrack", true);
			self.sourceParticleLayer = args.stageLayer.privateLayer;
			// intialized in first onAnimate call
			self.sourceTrackItem = null; 
			self.scene = null;
		},

		onParamChanged: function (self, id, oldValue, newValue) { // method on behavior (any phase)
			Z.Utils.assert(false, kAbout + " not expecting onParamChanged()");
		},

		addSplat: function (self, args, pos) {
			var dof, track, view = self.sourceParticleLayer.getView();
			
			if (! self.sourceTrackItem) {
				self.sourceTrackItem = self.sourceParticleLayer.getTrackItem();
				self.scene = self.sourceParticleLayer.getScene();
				track = self.sourceParticleLayer.getTrack();
				self.particleTrack.setParentOffsetTime(track.getParentOffsetTime());
				self.particleTrack.setTrimInTime(track.getTrimInTime());
				self.particleTrack.setTrimOutTime(track.getTrimOutTime());
				var idx = track.getParent().getChildren().indexOf(track);
				self.scene.addChild(self.particleTrack, idx);
			}

			// create new particle and corresponding track item
			var particleTrackItem = self.sourceTrackItem.clone(),
				particleLayer = self.sourceParticleLayer.clone();
			particleLayer.prepareState();

			particleTrackItem.setSourceLayer(particleLayer);
			self.particleTrack.addChild(particleTrackItem);
			particleTrackItem.displayInView(view);
			
			dof = particleLayer.getHandleTreeRoot();

			var matScene_Layer = args.getLayerMatrixRelativeToScene(particleLayer),
				matLayer_Scene = m3.invert(matScene_Layer), mDof;

			var rootPosition = [], rootScale = [], rootShear = [], rootRotation = [];
			m3.decomposeAffine(mDof, rootPosition, rootScale, rootShear, rootRotation);

			rootPosition = pos;
			mDof = m3.affine(rootPosition, [1, 1], [0], 0);

			tasks.handle.setFrame(dof, tasks.handle.convertLayerFrame(dof, m3.multiply(matLayer_Scene, mDof)), kAffine);

			self.aParticleLayer.push(particleLayer);
			console.log ("Created particle (" + self.aParticleLayer.length + " total)");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage

			var rDown = args.getParamEventValue("KeyboardInput", rKeyCode) || 0,
				dDown = args.getParamEventValue("KeyboardInput", dKeyCode) || 0,
				replicateWhileDownB = args.getParam("ReplicateWhileMouseDown"),
				i, p;

			function removePuppetFromView(particleLayer)
			{
				var trackItem = particleLayer.getTrackItem(),
					view = particleLayer.getView();
				trackItem.removeFromView(view);
				self.particleTrack.removeChild(trackItem);
			}

			if (dDown) {
				args.setEventGraphParamRecordingValid("KeyboardInput");
				for (i = 0; i < self.aParticleLayer.length; i += 1) {
					p = self.aParticleLayer[i];
					removePuppetFromView(p);
				}
				self.aParticleLayer = [];
			}
			var mousePosition = args.getParamEventValue("MouseInput", "Mouse/Position"),
				overValue = args.getParamEventValue("MouseInput", "Mouse/Over"),
				leftDownB = args.getParamEventValue("MouseInput", "Mouse/Down/Left");
			if (overValue && mousePosition) {
				var rChanged = rDown > self.lastDown, downReplicateB = leftDownB && replicateWhileDownB;
				if (downReplicateB || rChanged) {
					if (rChanged) {
						args.setEventGraphParamRecordingValid("KeyboardInput");
					}
					if (downReplicateB) {
						args.setEventGraphParamRecordingValid("MouseInput");
					}

					self.lastDown = rDown;

					this.addSplat(self, args, mousePosition);
				}
			}
			
			var touchEvents = args.getParamEventValue("MouseInput", "Touch/IndexToID/Count"),
					touchIdx, touchId, touchIdKey, touchPos, touchDown;
			
			if (touchEvents && replicateWhileDownB) {
				for (touchIdx = 0; touchIdx < touchEvents; touchIdx += 1) {
					touchId = args.getParamEventValue("MouseInput", "Touch/IndexToID/" + touchIdx);
					if (touchId !== undefined) {
						touchIdKey = "Touch/ID/" + touchId;
						touchDown = args.getParamEventValue("MouseInput", touchIdKey + "/Down");
						if (touchDown) {
							args.setEventGraphParamRecordingValid("MouseInput");
							touchPos = args.getParamEventValue("MouseInput", touchIdKey + "/Position");
							if (touchPos) {
								this.addSplat(self, args, touchPos);
								args.setEventGraphParamRecordingValid("MouseInput");
							}
						}
					}
				}
			}
		}

	}; // end of object being returned
});
